//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Wireless Souls
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
//
// Quick script that allows you to create a network of souls to transfer your souls wirelessly
//------------------------------------------------------------------------------------------------------------------------------------------------

// Format to display the souls
const wsSoulsDisplay = "Souls: %souls";

// The max number of souls in the network
const wsNetworkLimit = 9000000000000000; // Roughly Number.MAX_SAFE_INTEGER (normalized)

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// Classes
const $PEFormatter = Java.loadClass("moze_intel.projecte.utils.TransmutationEMCFormatter");
const $FormatText = Java.loadClass("net.minecraft.network.chat.FormattedText");

// Handles transfer of the value from the server
NetworkEvents.dataReceived("wireless_soul_display", event => {
    const player = event.getEntity();
    const data = event.getData();
    const pData = player.getData();

    if (data.toggleSouls !== undefined)
        pData.put("soulDisplay", data.toggleSouls);

    if (data.soulsValue !== undefined)
    {
        pData.put("oldSoulsData", pData.getOrDefault("soulsData", 0));
        pData.put("soulsData", data.soulsValue ?? 0);
    }
});

// Format the number
function formatNumber(number)
{
    return number.toLocaleString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}

function formatDisplay(souls)
{
    return wsSoulsDisplay.replace("%souls", souls);
}

function formatRate(rate, color, max)
{
    const rateText = Client.isShiftDown() ? formatNumber(Math.abs(rate)) : $PEFormatter.formatEMC(Math.abs(rate)).getString();

    if (max)
        return { text: " (Maxed)", color: color[2] };

    if (rate < 0)
        return { text: ` -${rateText}/s`, color: color[0] };
    else if (rate > 0)
        return { text: ` +${rateText}/s`, color: color[1] };

    return { text: "", color: color[0] };
}

// Builds the Screen Info
ClientEvents.leftDebugInfo(event => {
    const player = Client.player;

    const data = Number(player.getData().getOrDefault("soulsData", 0));
    const oldData = Number(player.getData().getOrDefault("oldSoulsData", 0));

    const rate = formatRate((data - oldData), ["§c", "§a", "§7"], data === wsNetworkLimit);

    const text = Client.isShiftDown()
                    ? formatDisplay(formatNumber(data), formatNumber(wsNetworkLimit)) 
                    : formatDisplay($PEFormatter.formatEMC(data).getString(), $PEFormatter.formatEMC(wsNetworkLimit).getString());

    event.getLines().add(text + rate.color + rate.text);
});

ClientEvents.loggedIn(event => {
    const player = event.getPlayer();
    const data = Number(player.getData().getOrDefault("soulsData", 0));

    player.paint({
        soulDisplay: {
            type: "text",
			text: formatDisplay($PEFormatter.formatEMC(data).getString(), $PEFormatter.formatEMC(wsNetworkLimit).getString()),
			x: 2,
			y: 12,
            z: 1,
            color: "#DDDDDD",
			draw: "always"
        },
        soulRateDisplay: {
            type: "text",
			text: "",
			x: 2,
			y: 12,
            z: 1,
            color: "#55FF55",
			draw: "always"
        },
        soulRectangle: {
            type: "rectangle",
            x: 1, 
            y: 11, 
            z: 0, 
            h: 9,
            w: 0,
            color: "#88444444",
            draw: "always"
        }
    });

})

let oldDisplay = true;

ClientEvents.tick(event => {
    // Get Constants
    const player = event.getPlayer();

    if (player === null)
        return;

    const shouldDisplay = player.getData().getOrDefault("soulDisplay", true);

    if (!shouldDisplay)
    {
        if (oldDisplay)
        {
            player.paint({ 
                soulDisplay: { text: "" },
                soulRateDisplay: { text: "" },
                soulRectangle: { w: 0 }
            });

            oldDisplay = false;
        }

        return;
    }

    const screen = Client.getCurrentScreen();
    const onScreen = screen !== null && screen.class.getName() !== "net.minecraft.client.gui.screens.ChatScreen";
    const font = Client.font;

    const color = onScreen ? "#444444" : "#DDDDDD"
    const bgColor = onScreen ? "#88202020" : "#88444444";
    const rateColor = onScreen ? ["#4A2121", "#214A21", "#313131"] : ["#FF5555", "#55FF55", "#AAAAAA"];

    const data = Number(player.getData().getOrDefault("soulsData", 0));
    const oldData = Number(player.getData().getOrDefault("oldSoulsData", 0));
    const rate = formatRate((data - oldData), rateColor, data === wsNetworkLimit);

    const text = Client.isShiftDown()
                    ? formatDisplay(formatNumber(data), formatNumber(wsNetworkLimit)) 
                    : formatDisplay($PEFormatter.formatEMC(data).getString(), $PEFormatter.formatEMC(wsNetworkLimit).getString());

    // Update Screen Info
    player.paint({ 
        soulDisplay: { text: text, color: color },
        soulRateDisplay: { x: font.getSplitter().stringWidth(text) + 2, text: rate.text, color: rate.color },
        soulRectangle: { w: font.getSplitter().stringWidth(text + rate.text) + 2, color: bgColor }
    });

    oldDisplay = true;
});